//////////////////////////////////////////////////////////////////////////////////
//hellofpga.com
//////////////////////////////////////////////////////////////////////////////////
`timescale 1ns / 1ps
module LED(
    input  CLK,      // Clock input
    input  RSTn,     // Reset input (active-low)
    output LED1,     
    output LED2    
    );
    
    parameter T1MS = 26'd50_000_000 ; // 50M crystal oscillator clock
    reg [25:0] time_count;
    always@(posedge CLK or negedge RSTn)
        if(!RSTn) begin  // When reset is active, set the counter to 0
            time_count <= 26'd0;
        end
        else begin  // When reset is not active
            if(time_count >= T1MS - 1'b1) // If the counter reaches 50_000_000, one second has passed
                time_count <= 26'd0;
            else 
                time_count <= time_count + 1'b1;  // Otherwise, increment the counter
        end
        
    reg [1:0] led_state;
    always@(posedge CLK or negedge RSTn)
        if(!RSTn) begin  // When reset is active, set LED state to 0
             led_state <= 2'd0;
        end
        else begin
             if(time_count == T1MS - 1'b1) begin  // One second
                if(led_state >= 2'd1) 
                    led_state <= 2'd0;  // Cycle between 0 and 2
                else 
                    led_state <= led_state + 1'b1;  // Increment state
            end
        end    
      
      assign LED1 = (led_state == 2'd0) ? 1'b1 : 1'b0;
      assign LED2 = (led_state == 2'd1) ? 1'b1 : 1'b0;
      
endmodule