/////////////////////////////
//www.hellofpga.com
/////////////////////////////
`timescale 1ns / 1ps 

module LED(
    input clk,      
    input rst_n,    
    output led      
);  

parameter T1MS = 26'd50_000_000;  
reg [25:0] time_count = 26'd0;    // Clock counter
reg led_r = 1'b0;                

always @(posedge clk or negedge rst_n) begin  
    if (!rst_n) begin  //rst_n
        time_count <= 26'd0;        
        led_r <= 1'b0;            
    end
    else if (time_count >= T1MS) begin  // If time count reaches 1ms
        time_count <= 26'd0;         
        led_r <= ~led_r;                // Toggle LED state
    end
    else begin
        time_count <= time_count + 1'b1;
    end
end

assign led = led_r; 

endmodule